require( "scripts/style.lua" )

HeaderFont = {
  standardFont,
  35,
  BlackColor
};

TableInfoFont = {
  standardFont,
  30,
 BlackColor
};

ErrorFont = {
  standardFont,
  24,
 BlackColor
};

AccountFont = {
  standardFont,
  24,
  BlackColor
};

ScoreFont = {
  standardFont,
  16,
  BlackColor
};

kPlayerNameY = 175;
kScoreY = 220;
kYourPFAccountY = 260;
kAccountNameY = 265;
kPasswordY = 300;
kRememberY = 345;
kOffsetX = 0;


MakeDialog
{
	
	Bitmap
	{ 
		image="backgrounds/longdialog",	
		x=kCenter,
		y=kCenter,

		Text
		{
			font = HeaderFont,
			name = "header",
			x=kCenter,y=120,w=300,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "submitglobal"
		};
		
		Text
		{
			font = AccountFont,
			name = "playertext",
			x=200 + kOffsetX,y=kPlayerNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "playerlabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "yourscore",
			x=200 + kOffsetX,y=kScoreY,w=150,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "scorelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "eligiblescore",
			x=360 + kOffsetX,y=kScoreY,w=100,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "12345"
		};
		
		Text
		{
			font = ScoreFont,
			name = "yourpfaccount",
			x=358 + kOffsetX,y=kYourPFAccountY,w=150,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "yourpfaccount"
		};
		
		Text
		{
			font = AccountFont,
			name = "nametext",
			x=200 + kOffsetX,y=kAccountNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "namelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "passtext",
			x=200 + kOffsetX,y=kPasswordY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "passwordlabel"
		};
		
		Text
		{
			font = TableInfoFont,
			name = "submitconnect",
			x=kCenter,y=0,w=300,h=kMax-20,
			flags = kHAlignCenter + kVAlignCenter,
			label = "connectingtoserver"
		};
		
		Text
		{
			font = ErrorFont,
			name = "submiterror",
			x=kCenter,y=0,w=300,h=kMax-20,
			flags = kHAlignCenter + kVAlignCenter,
			label = "Error Message"
		};


		Bitmap
		{
			name="nameeditbox",
			image="backgrounds/textfield.png",
			x=355 + kOffsetX,
			y=kPlayerNameY-15,
			
			TextEdit
			{
				font = AccountFont,
				name = "nameedit",
				x=6,y=17,w=kMax,h=kMax,
				length=12,
				ignore = kIllegalNameChars
				
			};
		};
		
		Bitmap
		{
			name="accounteditbox",
			image="backgrounds/textfield.png",
			x=355 + kOffsetX,
			y=kAccountNameY-15,
			
			TextEdit
			{
				font = AccountFont,
				name = "accountedit",
				x=6,y=17,w=kMax,h=kMax,
				length=26,
				ignore = kIllegalNameChars
				
			};
		};
		
		Bitmap
		{
			name="passeditbox",
			image="backgrounds/textfield.png",
			x=355 + kOffsetX,
			y=kPasswordY-15,
			
			TextEdit
			{
				font = AccountFont,
				name = "passedit",
				x=6,y=17,w=kMax,h=kMax,
				password = true,
				length=26
				
			};
		};
		
		
		Button
		{
			font = StandardButtonFont,
			graphics = CheckboxButtonGraphics,
			name="remember",
			type = kToggle,
			x=275 + kOffsetX,
			y=kRememberY,
			w=250,
			scale=0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/click.ogg",
			Text
			{
				font = DialogBodyFont,
				name = "rememberlabel",
				x=30,
				y=0,
				w=250,
				h=25,
				flags = kHAlignLeft + kVAlignTop,
				label="rememberpfaccount",
			};
		};
		
		Button
		{
			x=250 + kOffsetX,
			y=375,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			default = true,
			name="submittoserver",
			label="submit",
			type = kPush
		},
		
		Text
		{
			font = HelpFont,
			name = "buttonPrivacy",
			x=kCenter,
			y=430,
			w=250,
			h=50,
			flags = kHAlignLeft + kVAlignTop,
			label ="submit_button_privacy_pf",
		},
		
		Button
		{
			x=437 + kOffsetX,
			y=375,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="submitcancel",
			label="cancel",
			type = kPush
		};
		
		Button
		{
			x=350 + kOffsetX,
			y=375,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			default = true,
			name="submiterrorok",
			label="ok",
			type = kPush
		};

		SetStyle(DefaultStyle);
		Button
		{
			name="privacypolicy",
			x=0,y=0,w=0,h=0,
			command = 
			    function()
				  LaunchPrivacyPolicy();
			    end
		};
	}
}